/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.controls.builtin;

import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.montoyo.wd.controls.ScreenControl;
import net.montoyo.wd.core.MissingPermissionException;
import net.montoyo.wd.entity.TileEntityScreen;
import net.montoyo.wd.utilities.BlockSide;

@Deprecated
public class ManageRightsAndUpdgradesControl
extends ScreenControl {
    public static final ResourceLocation id = new ResourceLocation("webdisplays:mod_rights_upgrades");
    ControlType type;
    boolean adding;
    ItemStack toRemove;
    private int friendRights;
    private int otherRights;

    public ManageRightsAndUpdgradesControl(boolean adding, ItemStack toRemove) {
        super(id);
        this.adding = adding;
        this.type = ControlType.UPGRADES;
        this.toRemove = toRemove;
    }

    public ManageRightsAndUpdgradesControl(int friendRights, int otherRights) {
        super(id);
        this.type = ControlType.RIGHTS;
        this.friendRights = friendRights;
        this.otherRights = otherRights;
    }

    public ManageRightsAndUpdgradesControl(FriendlyByteBuf buf) {
        super(id);
        this.type = ControlType.values()[buf.readByte()];
        switch (this.type) {
            case UPGRADES: {
                this.adding = buf.readBoolean();
                this.toRemove = buf.m_130267_();
                break;
            }
            case RIGHTS: {
                this.friendRights = buf.readInt();
                this.otherRights = buf.readInt();
            }
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeByte(this.type.ordinal());
        switch (this.type) {
            case UPGRADES: {
                buf.writeBoolean(this.adding);
                buf.m_130055_(this.toRemove);
                break;
            }
            case RIGHTS: {
                buf.writeInt(this.friendRights);
                buf.writeInt(this.otherRights);
            }
        }
    }

    @Override
    public void handleServer(BlockPos pos, BlockSide side, TileEntityScreen tes, NetworkEvent.Context ctx, Function<Integer, Boolean> permissionChecker) throws MissingPermissionException {
        ServerPlayer player = ctx.getSender();
        switch (this.type) {
            case UPGRADES: {
                this.checkPerms(16, permissionChecker, ctx.getSender());
                if (this.adding) {
                    throw new RuntimeException("Cannot add an upgrade from the client");
                }
                tes.removeUpgrade(side, this.toRemove, (Player)player);
                break;
            }
            case RIGHTS: {
                int or;
                TileEntityScreen.Screen scr = tes.getScreen(side);
                int fr = scr.owner.uuid.equals(player.m_36316_().getId()) ? this.friendRights : scr.friendRights;
                int n = or = (scr.rightsFor((Player)player) & 8) == 0 ? scr.otherRights : this.otherRights;
                if (scr.friendRights == fr && scr.otherRights == or) break;
                tes.setRights(player, side, fr, or);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handleClient(BlockPos pos, BlockSide side, TileEntityScreen tes, NetworkEvent.Context ctx) {
        ServerPlayer player = ctx.getSender();
        switch (this.type) {
            case UPGRADES: {
                if (this.adding) {
                    tes.addUpgrade(side, this.toRemove, (Player)player, true);
                    break;
                }
                tes.removeUpgrade(side, this.toRemove, (Player)player);
                break;
            }
            case RIGHTS: {
                TileEntityScreen.Screen scr = tes.getScreen(side);
                int fr = this.friendRights;
                int or = this.otherRights;
                if (scr.friendRights == fr && scr.otherRights == or) break;
                tes.setRights(player, side, fr, or);
            }
        }
    }

    public static enum ControlType {
        RIGHTS,
        UPGRADES;

    }
}

